// application base class
Application_class	= Object_class:create( "Application_class" );

// application create method.
function Application_class:create( create_vgui, window_type )
	// create app object
	local obj = {};
	setmetatable( obj, self );
	self.__index = self;

	// controls list
	obj.controls = {};
	
	// events.
	obj.events = {};
	
	// create app window.
	if( create_vgui ) then
		obj.window = vgui.Create( "app_window" );
		obj.window:LinkToClass( obj );
		
	end
		
	//
	return obj;
	
end

// add event handler.
function Application_class:AddEvent( event, func )
	// add to this event.
	self.events[event] = self.events[event] or {};
	table.insert( self.events[event], func );

end

// call event
function Application_class:CallEvent( event, ... )
	self.events[event] = self.events[event] or {};
	
	// call all items in this event.
	local func, ret;
	for _, func in pairs( self.events[event] ) do
		if( self[func] ) then
			ret = self[func]( self, unpack( arg ) );
		end
	end
	
	//
	return ret;
	
end


// pos/size
function Application_class:SetSize( w, h )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetSize( w, h );
	
end
function Application_class:SetPos( x, y )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetPos( x, y );
	
end

// get pos
function Application_class:GetPos( )
	// valid?
	if( !self:ValidHandle() ) then return 0, 0; end
	
	local x, y = self.window:GetPos();
	return x, y;
	
end

// get size
function Application_class:GetSize( )
	// valid?
	if( !self:ValidHandle() ) then return 0, 0; end
	
	local w, h = self.window:GetSize();
	return w, h;
	
end

// set caption
function Application_class:SetCaption( text )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window.Caption:SetText( text );
	
end

// set icon
function Application_class:SetIcon( mat )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetIcon( mat );
	
end

// visibility
function Application_class:Show( )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetVisible( true );
	
	self:CallEvent( "OnShow" );

end
function Application_class:Hide( )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetVisible( false );
	
	self:CallEvent( "OnHide" );
	
end
function Application_class:IsVisible( )
	// valid?
	if( !self:ValidHandle() ) then return false; end
	
	//
	return self.window:IsVisible();
	
end

// get window handle
function Application_class:GetHandle( )
	return self.window;
	
end

// handle valid
function Application_class:ValidHandle( )
	return self.window != nil;
	
end


// set attributes.
function Application_class:SetAttrb( moveable, sizeable, closeable, caption, drawwindow )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	// set attributes.
	self.window.Moveable = moveable;
	self.window.Sizeable = sizeable;
	self.window.Closeable = closeable;
	self.window.HasCaption = caption;
	self.window.DrawWindow = drawwindow;
	
end

// set nodraw.
function Application_class:SetNoDraw( v )
	// valid?
	if( !self:ValidHandle() ) then return; end

	self.window.DrawWindow = v;
	
end


// new app
function AppFramework_class:NewApplication( name, create_vgui, window_type )
	// create application, store in app list.
	local app = Application_class:create( create_vgui or true, window_type );
	
	// add
	table.insert( self.applications, app );
	
	//
	return app;
	
end
